/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.v8debug.ui.vars.models;

import java.awt.Color;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.netbeans.lib.v8debug.PropertyLong;
import org.netbeans.lib.v8debug.V8Arguments;
import org.netbeans.lib.v8debug.V8Command;
import org.netbeans.lib.v8debug.V8Frame;
import org.netbeans.lib.v8debug.V8Request;
import org.netbeans.lib.v8debug.V8Response;
import org.netbeans.lib.v8debug.V8Scope;
import org.netbeans.lib.v8debug.commands.Scope;
import org.netbeans.lib.v8debug.commands.SetVariableValue;
import org.netbeans.lib.v8debug.vars.NewValue;
import org.netbeans.lib.v8debug.vars.ReferencedValue;
import org.netbeans.lib.v8debug.vars.V8Object;
import org.netbeans.lib.v8debug.vars.V8Value;
import org.netbeans.modules.javascript.v8debug.ReferencedValues;
import org.netbeans.modules.javascript.v8debug.V8Debugger;
import org.netbeans.modules.javascript.v8debug.frames.CallFrame;
import org.netbeans.modules.javascript.v8debug.ui.vars.models.Bundle;
import org.netbeans.modules.javascript.v8debug.vars.EvaluationError;
import org.netbeans.modules.javascript.v8debug.vars.ScopeValue;
import org.netbeans.modules.javascript.v8debug.vars.V8Evaluator;
import org.netbeans.modules.javascript.v8debug.vars.VarValuesLoader;
import org.netbeans.modules.javascript.v8debug.vars.Variable;
import org.netbeans.modules.javascript2.debug.NamesTranslator;
import org.netbeans.modules.javascript2.debug.ui.models.ViewModelSupport;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ExtendedNodeModel;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.WeakSet;
import org.openide.util.datatransfer.PasteType;

public class VariablesModel
extends ViewModelSupport
implements TreeModel,
ExtendedNodeModel,
TableModel,
V8Debugger.Listener {
    private static final String ICON_LOCAL = "org/netbeans/modules/debugger/resources/localsView/local_variable_16.png";
    private static final String ICON_SCOPE = "org/netbeans/modules/javascript2/debug/ui/resources/global_variable_16.png";
    protected final V8Debugger dbg;
    private final VarValuesLoader vvl;
    private volatile boolean topFrameRefreshed;
    private final Set<Variable> refreshWhenLoaded = Collections.synchronizedSet(new WeakSet());

    public VariablesModel(ContextProvider contextProvider) {
        this.dbg = (V8Debugger)contextProvider.lookupFirst(null, V8Debugger.class);
        this.dbg.addListener((V8Debugger.Listener)this);
        this.vvl = (VarValuesLoader)contextProvider.lookupFirst(null, VarValuesLoader.class);
    }

    public Object getRoot() {
        return "Root";
    }

    public Object[] getChildren(Object parent, int from, int to) throws UnknownTypeException {
        if (parent == "Root") {
            boolean incompleteValue;
            V8Value v;
            long ref;
            ReferencedValue rv;
            String name;
            CallFrame cf = this.dbg.getCurrentFrame();
            if (cf == null) {
                return EMPTY_CHILDREN;
            }
            NamesTranslator nt = cf.getNamesTranslator();
            V8Frame frame = cf.getFrame();
            Map argumentRefs = frame.getArgumentRefs();
            Map localRefs = frame.getLocalRefs();
            V8Scope[] scopes = frame.getScopes();
            int numscopes = 0;
            for (V8Scope scope : scopes) {
                if (V8Scope.Type.Local.equals((Object)scope.getType())) continue;
                ++numscopes;
            }
            int n = argumentRefs.size() + localRefs.size() + numscopes;
            Object[] ch = new Object[n];
            int i = 0;
            ReferencedValues rvals = cf.getRvals();
            for (Map.Entry namerv : argumentRefs.entrySet()) {
                name = (String)namerv.getKey();
                if (name == null) {
                    name = Bundle.CTL_Argument(i + 1);
                } else if (nt != null) {
                    name = nt.translate(name);
                }
                rv = (ReferencedValue)namerv.getValue();
                ref = rv.getReference();
                v = rvals.getReferencedValue(ref);
                incompleteValue = false;
                if (v == null) {
                    v = rv.getValue();
                    incompleteValue = true;
                }
                ch[i++] = new Variable(Variable.Kind.ARGUMENT, name, ref, v, incompleteValue);
            }
            for (Map.Entry entry : localRefs.entrySet()) {
                name = (String)entry.getKey();
                rv = (ReferencedValue)entry.getValue();
                ref = rv.getReference();
                v = rvals.getReferencedValue(ref);
                incompleteValue = false;
                if (v == null) {
                    v = rv.getValue();
                    incompleteValue = true;
                }
                if (nt != null) {
                    name = nt.translate(name);
                }
                ch[i++] = new Variable(Variable.Kind.LOCAL, name, ref, v, incompleteValue);
            }
            for (V8Scope scope : scopes) {
                if (V8Scope.Type.Local.equals((Object)scope.getType())) continue;
                ch[i++] = new ScopeValue(scope);
            }
            return ch;
        }
        if (parent instanceof Variable) {
            V8Value value;
            Variable vl = (Variable)parent;
            try {
                value = this.vvl.getValue(vl);
            }
            catch (EvaluationError ee) {
                value = null;
            }
            if (value instanceof V8Object) {
                V8Object obj = (V8Object)value;
                return this.getObjectChildren(obj);
            }
            return EMPTY_CHILDREN;
        }
        if (parent instanceof ScopeValue) {
            ScopeValue sv = (ScopeValue)parent;
            V8Scope scope = sv.getScope();
            V8Object sobj = sv.getValue();
            if (sobj == null) {
                CallFrame cf;
                ReferencedValue sobjr = scope.getObject();
                if (sobjr != null && (sobj = (V8Object)sobjr.getValue()) == null && (cf = this.dbg.getCurrentFrame()) != null) {
                    sobj = (V8Object)cf.getRvals().getReferencedValue(sobjr.getReference());
                }
                if (sobj == null) {
                    sv = this.loadScope(sv);
                    sobj = sv.getValue();
                }
            }
            if (sobj == null) {
                return EMPTY_CHILDREN;
            }
            return this.getObjectChildren(sobj, sv.getScope());
        }
        return EMPTY_CHILDREN;
    }

    protected final Object[] getObjectChildren(V8Object obj) {
        return this.getObjectChildren(obj, null);
    }

    protected final Object[] getObjectChildren(V8Object obj, V8Scope scope) {
        V8Object.Array array = obj.getArray();
        ArrayList<Variable> children = null;
        if (array != null) {
            children = new ArrayList<Variable>();
            V8Object.IndexIterator indexIterator = array.getIndexIterator();
            while (indexIterator.hasNextIndex()) {
                long index = indexIterator.nextIndex();
                children.add(new Variable(Variable.Kind.ARRAY_ELEMENT, Long.toString(index), array.getReferenceAt(index), null, true, scope));
            }
        }
        Map properties = obj.getProperties();
        Object[] childrenRet = children == null ? new Object[properties.size()] : null;
        int chi = 0;
        for (Map.Entry entry : properties.entrySet()) {
            String name = (String)entry.getKey();
            V8Object.Property property = (V8Object.Property)entry.getValue();
            Variable var = new Variable(Variable.Kind.PROPERTY, name, property.getReference(), null, true, scope);
            if (children != null) {
                children.add(var);
                continue;
            }
            childrenRet[chi++] = var;
        }
        if (children != null) {
            childrenRet = children.toArray();
        }
        return childrenRet;
    }

    public boolean isLeaf(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return false;
        }
        if (node instanceof Variable) {
            Variable var = (Variable)node;
            try {
                V8Value value = var.getValue();
                if ((value == null || value instanceof V8Object) && var.hasIncompleteValue()) {
                    return false;
                }
                return !VariablesModel.hasChildren(value);
            }
            catch (EvaluationError evaluationError) {
                // empty catch block
            }
        }
        return !(node instanceof ScopeValue);
    }

    public static boolean hasChildren(V8Value value) {
        if (value instanceof V8Object) {
            V8Object obj = (V8Object)value;
            V8Object.Array array = obj.getArray();
            Map properties = obj.getProperties();
            return array != null && array.getLength() > 0L || properties != null && !properties.isEmpty();
        }
        return false;
    }

    public int getChildrenCount(Object node) throws UnknownTypeException {
        return Integer.MAX_VALUE;
    }

    public boolean canRename(Object node) throws UnknownTypeException {
        return false;
    }

    public boolean canCopy(Object node) throws UnknownTypeException {
        return false;
    }

    public boolean canCut(Object node) throws UnknownTypeException {
        return false;
    }

    public Transferable clipboardCopy(Object node) throws IOException, UnknownTypeException {
        return null;
    }

    public Transferable clipboardCut(Object node) throws IOException, UnknownTypeException {
        return null;
    }

    public PasteType[] getPasteTypes(Object node, Transferable t) throws UnknownTypeException {
        return null;
    }

    public void setName(Object node, String name) throws UnknownTypeException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getIconBaseWithExtension(Object node) throws UnknownTypeException {
        if (node instanceof Variable) {
            Variable.Kind varKind = ((Variable)node).getKind();
            switch (varKind) {
                default: 
            }
            return ICON_LOCAL;
        }
        if (node instanceof ScopeValue) {
            return ICON_SCOPE;
        }
        throw new UnknownTypeException(node);
    }

    public String getDisplayName(Object node) throws UnknownTypeException {
        if (node instanceof Variable) {
            return ((Variable)node).getName();
        }
        if (node instanceof ScopeValue) {
            V8Scope scope = ((ScopeValue)node).getScope();
            String text = scope.getText();
            if (text == null) {
                text = scope.getType().toString();
            }
            return text + " Scope";
        }
        throw new UnknownTypeException(node);
    }

    public String getIconBase(Object node) throws UnknownTypeException {
        throw new UnsupportedOperationException("Not supported.");
    }

    public String getShortDescription(Object node) throws UnknownTypeException {
        if (node instanceof Variable) {
            String strVal;
            Variable var = (Variable)node;
            try {
                V8Value value = var.getValue();
                if (value == null) {
                    return null;
                }
                strVal = V8Evaluator.getStringValue((V8Value)value);
            }
            catch (EvaluationError ee) {
                strVal = ">" + ee.getLocalizedMessage() + "<";
            }
            return var.getName() + " = " + strVal;
        }
        return null;
    }

    public Object getValueAt(Object node, String columnID) throws UnknownTypeException {
        if (node == "Root") {
            return "";
        }
        if (node instanceof Variable) {
            Variable var = (Variable)node;
            V8Value value = null;
            EvaluationError ee = null;
            try {
                boolean wasIncomplete = var.hasIncompleteValue();
                value = this.vvl.getValue(var);
                if (wasIncomplete) {
                    if (this.refreshWhenLoaded.remove(var)) {
                        this.fireChangeEvent((ModelEvent)new ModelEvent.TableValueChanged((Object)this, node, null));
                    }
                    if (!VariablesModel.hasChildren(value)) {
                        this.fireChangeEvent((ModelEvent)new ModelEvent.NodeChanged((Object)this, node, 8));
                    }
                }
            }
            catch (EvaluationError ex) {
                ee = ex;
            }
            if ("LocalsValue".equals(columnID) || "LocalsToString".equals(columnID)) {
                if (value != null) {
                    return VariablesModel.toHTML((String)V8Evaluator.getStringValue((V8Value)value));
                }
                return VariablesModel.toHTML((String)ee.getLocalizedMessage(), (boolean)true, (boolean)false, (Color)Color.red);
            }
            if ("LocalsType".equals(columnID)) {
                if (value != null) {
                    return VariablesModel.toHTML((String)V8Evaluator.getStringType((V8Value)value));
                }
                return "";
            }
        } else if (node instanceof ScopeValue) {
            return "";
        }
        throw new UnknownTypeException(node);
    }

    public boolean isReadOnly(Object node, String columnID) throws UnknownTypeException {
        if ("LocalsValue".equals(columnID) && node instanceof Variable) {
            Variable var = (Variable)node;
            switch (var.getKind()) {
                case ARGUMENT: 
                case LOCAL: {
                    return this.isReadOnlyType(var);
                }
                case ARRAY_ELEMENT: {
                    return true;
                }
                case PROPERTY: {
                    if (var.getScope() != null) {
                        return this.isReadOnlyType(var);
                    }
                    return true;
                }
            }
            return this.isReadOnlyType(var);
        }
        return true;
    }

    private boolean isReadOnlyType(Variable var) {
        try {
            V8Value value = var.getValue();
            if (value == null) {
                this.refreshWhenLoaded.add(var);
                return true;
            }
            return VariablesModel.isReadOnly(value);
        }
        catch (EvaluationError ee) {
            return true;
        }
    }

    static boolean isReadOnly(V8Value value) {
        switch (value.getType()) {
            case Context: 
            case Error: 
            case Frame: 
            case Function: 
            case Promise: {
                return true;
            }
        }
        return false;
    }

    public void setValueAt(final Object node, String columnID, Object value) throws UnknownTypeException {
        if (!(value instanceof String)) {
            throw new UnknownTypeException((Object)("Accepting String values only. Not " + value));
        }
        if ("LocalsValue".equals(columnID) && node instanceof Variable) {
            V8Value evalVal;
            long frameNumber;
            long scopeNumber;
            final Variable var = (Variable)node;
            CallFrame cf = this.dbg.getCurrentFrame();
            if (cf == null) {
                return;
            }
            V8Scope scope = var.getScope();
            if (scope != null) {
                scopeNumber = scope.getIndex();
                frameNumber = scope.getFrameIndex().hasValue() ? scope.getFrameIndex().getValue() : cf.getFrame().getIndex().getValue();
            } else {
                scopeNumber = 0L;
                frameNumber = cf.getFrame().getIndex().getValue();
            }
            try {
                evalVal = V8Evaluator.evaluate((V8Debugger)this.dbg, (String)((String)value));
            }
            catch (EvaluationError ee) {
                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)ee.getLocalizedMessage(), 0));
                return;
            }
            long newHandle = evalVal.getHandle();
            this.dbg.sendCommandRequest(V8Command.SetVariableValue, (V8Arguments)new SetVariableValue.Arguments(var.getName(), new NewValue(newHandle), scopeNumber, Long.valueOf(frameNumber)), new V8Debugger.CommandResponseCallback(){
                final /* synthetic */ VariablesModel this$0;
                {
                    this.this$0 = this$0;
                }

                public void notifyResponse(V8Request request, V8Response response) {
                    if (response != null) {
                        String errorMessage = response.getErrorMessage();
                        if (errorMessage != null) {
                            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)errorMessage, 0));
                        } else {
                            this.this$0.vvl.updateValue(var, evalVal);
                            this.this$0.fireChangeEvent((ModelEvent)new ModelEvent.TableValueChanged((Object)this.this$0, node, null, 1));
                        }
                    }
                }
            });
        }
    }

    public void notifySuspended(boolean suspended) {
        this.refresh();
        this.topFrameRefreshed = suspended;
    }

    public void notifyCurrentFrame(CallFrame cf) {
        if (cf == null) {
            return;
        }
        if (this.topFrameRefreshed && cf.isTopFrame()) {
            return;
        }
        this.topFrameRefreshed = false;
        this.refresh();
    }

    public void notifyFinished() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ScopeValue loadScope(ScopeValue scopeValue) {
        boolean[] isSet;
        ScopeValue[] newScopeRef;
        V8Scope scope = scopeValue.getScope();
        PropertyLong frameIndex = scope.getFrameIndex();
        Scope.Arguments sa = frameIndex.hasValue() ? new Scope.Arguments(scope.getIndex(), Long.valueOf(frameIndex.getValue())) : new Scope.Arguments(scope.getIndex());
        V8Request cmdRequest = this.dbg.sendCommandRequest(V8Command.Scope, (V8Arguments)sa, new V8Debugger.CommandResponseCallback(){
            final /* synthetic */ ScopeValue[] val$newScopeRef;
            final /* synthetic */ boolean[] val$isSet;
            final /* synthetic */ VariablesModel this$0;
            {
                this.val$newScopeRef = scopeValueArray;
                this.val$isSet = blArray;
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void notifyResponse(V8Request request, V8Response response) {
                if (response != null && response.isSuccess()) {
                    Scope.ResponseBody srb = (Scope.ResponseBody)response.getBody();
                    ScopeValue[] scopeValueArray = this.val$newScopeRef;
                    synchronized (this.val$newScopeRef) {
                        V8Object obj;
                        V8Scope scope = srb.getScope();
                        if (!scope.getObject().hasValue()) {
                            long ref = scope.getObject().getReference();
                            obj = (V8Object)response.getReferencedValue(ref);
                        } else {
                            obj = (V8Object)scope.getObject().getValue();
                        }
                        this.val$newScopeRef[0] = new ScopeValue(scope, obj);
                        this.val$isSet[0] = true;
                        this.val$newScopeRef.notifyAll();
                        // ** MonitorExit[var4_5] (shouldn't be in output)
                    }
                }
                ScopeValue[] scopeValueArray = this.val$newScopeRef;
                synchronized (this.val$newScopeRef) {
                    this.val$isSet[0] = true;
                    this.val$newScopeRef.notifyAll();
                    // ** MonitorExit[var3_4] (shouldn't be in output)
                    return;
                }
            }
        });
        if (cmdRequest == null) return scopeValue;
        ScopeValue[] scopeValueArray = newScopeRef;
        synchronized (newScopeRef) {
            if (!isSet[0]) {
                try {
                    newScopeRef.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (newScopeRef[0] == null) return scopeValue;
            scopeValue.setValue(newScopeRef[0].getValue());
            // ** MonitorExit[var8_8] (shouldn't be in output)
            return scopeValue;
        }
    }
}

