/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api.ui.swing;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Point;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.Popup;
import javax.swing.text.JTextComponent;
import org.netbeans.validation.api.Problem;
import org.netbeans.validation.api.Validator;
import org.netbeans.validation.api.ValidatorUtils;
import org.netbeans.validation.api.ui.GroupValidator;
import org.netbeans.validation.api.ui.ValidationGroup;
import org.netbeans.validation.api.ui.ValidationListener;
import org.netbeans.validation.api.ui.ValidationListenerFactory;
import org.netbeans.validation.api.ui.ValidationStrategy;
import org.netbeans.validation.api.ui.ValidationUI;
import org.netbeans.validation.api.ui.swing.MultilineLabel;
import org.netbeans.validation.api.ui.swing.MultilineLabelUI;
import org.netbeans.validation.api.ui.swing.SwingComponentDecorationFactory;

public final class SwingValidationGroup
extends ValidationGroup {
    private final SwingComponentDecorationFactory decorator;
    private static final String CLIENT_PROP_NAME = "_name";

    private SwingValidationGroup(GroupValidator additionalGroupValidation, SwingComponentDecorationFactory decorator, ValidationUI ... ui) {
        super(additionalGroupValidation, ui);
        if (ui == null) {
            throw new NullPointerException();
        }
        this.decorator = decorator != null ? decorator : SwingComponentDecorationFactory.getDefault();
    }

    public static SwingValidationGroup create(ValidationUI ... ui) {
        assert (EventQueue.isDispatchThread()) : "Must be called on event thread";
        return new SwingValidationGroup(null, null, ui);
    }

    public static SwingValidationGroup create(GroupValidator additionalGroupValidation, ValidationUI ... ui) {
        assert (EventQueue.isDispatchThread()) : "Must be called on event thread";
        return new SwingValidationGroup(additionalGroupValidation, null, ui);
    }

    public static SwingValidationGroup create(GroupValidator additionalGroupValidation, SwingComponentDecorationFactory decorator, ValidationUI ... ui) {
        assert (EventQueue.isDispatchThread()) : "Must be called on event thread";
        return new SwingValidationGroup(additionalGroupValidation, decorator, ui);
    }

    final SwingComponentDecorationFactory getComponentDecorationFactory() {
        return this.decorator;
    }

    @Override
    protected final <T> ValidationUI decorationFor(T comp) {
        ValidationUI dec = comp instanceof JComponent ? this.getComponentDecorationFactory().decorationFor((JComponent)comp) : ValidationUI.NO_OP;
        return dec;
    }

    @SafeVarargs
    public final void add(JTextComponent comp, Validator<String> ... validators) {
        assert (EventQueue.isDispatchThread()) : "Must be called on event thread";
        assert (validators.length > 0) : "Empty validator array";
        Validator merged = ValidatorUtils.merge(validators);
        ValidationListener<JTextComponent> vl = ValidationListenerFactory.createValidationListener(comp, ValidationStrategy.DEFAULT, this.getComponentDecorationFactory().decorationFor(comp), merged);
        this.addItem(vl, false);
    }

    public final void add(JTextComponent comp, Validator<String> validator) {
        assert (EventQueue.isDispatchThread()) : "Must be called on event thread";
        ValidationListener<JTextComponent> vl = ValidationListenerFactory.createValidationListener(comp, ValidationStrategy.DEFAULT, this.getComponentDecorationFactory().decorationFor(comp), validator);
        this.addItem(vl, false);
    }

    public final void add(JComboBox box, Validator<String> ... validators) {
        assert (EventQueue.isDispatchThread()) : "Must be called on event thread";
        this.addItem(ValidationListenerFactory.createValidationListener(box, ValidationStrategy.DEFAULT, ValidationUI.NO_OP, ValidatorUtils.merge(validators)), false);
    }

    public final void add(JComboBox box, Validator<String> validator) {
        assert (EventQueue.isDispatchThread()) : "Must be called on event thread";
        this.addItem(ValidationListenerFactory.createValidationListener(box, ValidationStrategy.DEFAULT, ValidationUI.NO_OP, validator), false);
    }

    public final void add(JList list, Validator<Integer[]> ... validators) {
        assert (EventQueue.isDispatchThread()) : "Must be called on event thread";
        this.addItem(ValidationListenerFactory.createValidationListener(list, ValidationStrategy.DEFAULT, this.getComponentDecorationFactory().decorationFor(list), ValidatorUtils.merge(validators)), false);
    }

    public final void add(JList list, Validator<Integer[]> validator) {
        assert (EventQueue.isDispatchThread()) : "Must be called on event thread";
        this.addItem(ValidationListenerFactory.createValidationListener(list, ValidationStrategy.DEFAULT, this.getComponentDecorationFactory().decorationFor(list), validator), false);
    }

    public final void add(AbstractButton[] buttons, Validator<Integer[]> ... validators) {
        assert (EventQueue.isDispatchThread()) : "Must be called on event thread";
        this.addItem(ValidationListenerFactory.createValidationListener(buttons, ValidationStrategy.DEFAULT, ValidationUI.NO_OP, ValidatorUtils.merge(validators)), false);
    }

    public final void add(AbstractButton[] buttons, Validator<Integer[]> validator) {
        assert (EventQueue.isDispatchThread()) : "Must be called on event thread";
        this.addItem(ValidationListenerFactory.createValidationListener(buttons, ValidationStrategy.DEFAULT, ValidationUI.NO_OP, validator), false);
    }

    public final JComponent createProblemLabel() {
        assert (EventQueue.isDispatchThread()) : "Must be called on event thread";
        MultilineLabel result = new MultilineLabel();
        this.addUI(result.createUI());
        return result;
    }

    static Popup createProblemPopup(Problem problem, Component target, Point relativeLocation) {
        return MultilineLabelUI.showPopup(problem, target, relativeLocation.x, relativeLocation.y);
    }

    public static String nameForComponent(JComponent jc) {
        String result = (String)jc.getClientProperty(CLIENT_PROP_NAME);
        if (result == null) {
            result = jc.getName();
        }
        return result;
    }

    public static void setComponentName(JComponent comp, String localizedName) {
        comp.putClientProperty(CLIENT_PROP_NAME, localizedName);
    }
}

