# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: cluster.proto for package 'gitaly'

require 'grpc'
require 'cluster_pb'

module Gitaly
  module RaftService
    # RaftService manages the sending of Raft messages to peers.
    class Service

      include ::GRPC::GenericService

      self.marshal_class_method = :encode
      self.unmarshal_class_method = :decode
      self.service_name = 'gitaly.RaftService'

      # SendMessage processes Raft messages and ensures they are handled by
      # the receiving node to update its Raft state machine.
      rpc :SendMessage, stream(::Gitaly::RaftMessageRequest), ::Gitaly::RaftMessageResponse
      # SendSnapshot sends raft snapshots from the leader to the follower node. Typically it
      # would be useful for nodes to catch up to the latest state.
      rpc :SendSnapshot, stream(::Gitaly::RaftSnapshotMessageRequest), ::Gitaly::RaftSnapshotMessageResponse
      # JoinCluster is called by the leader to instruct a new node to join an existing cluster.
      rpc :JoinCluster, ::Gitaly::JoinClusterRequest, ::Gitaly::JoinClusterResponse
      # GetPartitions retrieves comprehensive information about the Raft cluster topology,
      # partition states, and replica health. This is useful for monitoring and debugging.
      # Returns a stream of partition information, one response per partition.
      rpc :GetPartitions, ::Gitaly::GetPartitionsRequest, stream(::Gitaly::GetPartitionsResponse)
      # GetClusterInfo retrieves cluster-wide statistics and overview information.
      # This is a unary RPC that returns only aggregated statistics, not partition details.
      rpc :GetClusterInfo, ::Gitaly::RaftClusterInfoRequest, ::Gitaly::RaftClusterInfoResponse
    end

    Stub = Service.rpc_stub_class
  end
end
