---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token Linear API token'
---

## Description

The response body contains content that matches the pattern of a Linear API token was identified. Personal API tokens can be used to access Linear's GraphQL API. A malicious actor with access to this token can read or write issues, projects and teams to Linear and any systems the account has been integrated with.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet).

To revoke a Linear API token:

- Sign in to your account at <https://linear.app/>
- Select your organization in the upper-left corner and select "Preferences"
- In the left-hand menu, select "API" under "My Account"
- Find the identified API key in the "Personal API Keys" section of the page
- Select "Revoke" next to the identified key
- When prompted, select "Revoke" in the "Revoke access?" dialog

For more information, please see [Linear's documentation on using personal API keys](https://developers.linear.app/docs/graphql/working-with-the-graphql-api#personal-api-keys).

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 798.66 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
