---
stage: AI-powered
group: Workflow Catalog
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: GitLab Duoプランナー
---

{{< details >}}

- プラン: Premium、Ultimate
- アドオン: GitLab Duo Core、Pro、またはEnterprise。
- 提供形態: GitLab.com
- ステータス: ベータ

{{< /details >}}

{{< history >}}

- GitLab 18.5で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/576618)されました。

{{< /history >}}

GitLab Duoプランナーは、GitLabの製品管理および計画ワークフローを支援する、特殊なAIエージェントです。これは、以下を組み合わせることで、より効果的に作業を整理、優先順位付け、および追跡するのに役立ちます:

- 製品管理の専門知識。
- イシューやエピックなど、GitLabの計画オブジェクトの認識。

以下のサポートが必要な場合は、GitLab Duoプランナーを使用してください:

- 優先順位付け: RICE、MoSCoW、WSJFなどのフレームワークを適用して、作業アイテムをランク付けします。
- 作業分解: イニシアチブをエピック、ストーリー、およびユーザーストーリーに分解します。
- 依存性分析: ブロッカーとなっている作業を特定し、アイテム間の関係を理解します。
- 計画セッション: スプリント、マイルストーン、または四半期ごとの計画を編成します。
- ステータスレポート: 進捗状況、リスク、ブロッカーの要約を生成します。
- バックログ管理: 古くなったイシュー、重複、または改善が必要なアイテムを特定します。
- 見積もり: 作業アイテムの相対的なサイジングまたは労力見積もりを提案します。

## GitLab Duoプランナーへのアクセス {#access-gitlab-duo-planner}

前提要件: 

- グループではなく、プロジェクトで作業している必要があります。
- ベータ期間中、GitLab Duoプランナーは読み取り専用モードです。

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. プロジェクトでイシュー、エピック、またはマージリクエストを開きます。
1. 右上隅で、**GitLab Duo Chatを開く**（{{< icon name="duo-chat" >}}）を選択します。画面の右側にドロワーが開きます。
1. **New chat**（新しいチャット）（{{< icon name="duo-chat-new" >}}）ドロップダウンリストから、**Duo Planner**（Duoプランナー）を選択します。
1. 計画に関連する質問またはリクエストを入力します。リクエストから最良の結果を得るには:

   - URL、フィルター条件、またはスコープなど、リクエストに関するコンテキストを提供します。
   - 優先順位付けフレームワークを希望する場合は、それを指定してください。
   - エージェントの前提がワークフローと一致しない場合は、説明を求めてください。

### プロンプトの例 {#example-prompts}

- 「RICEフレームワークを使用して、「ラベル（ラベル名を挿入）付きのバックログ内のイシューの優先順位付けを手伝ってください。」
- 「顧客への影響に基づいて、（条件を入力）という条件でMoSCoWを使用してストーリーを分類します。」
- 「「ボード」のラベルが付いたバグのうち、ユーザーへの影響を考慮して、最初に修正する必要があるのはどれですか？」
- 「これらのエピックをQ1の戦略的価値でランク付けします。」
- 「新しい機能に対して技術的負債の優先順位付けを支援します。」
- 「労力対影響マトリックスを使用して、これらの機能を（URLを入力）比較します。」
- 「締め切りに間に合うように、このエピックの子アイテムのうち、現在のスコープから削除する必要があるものはどれですか？」
- 「このイニシアチブ（URLを入力）を、提供する必要がある主要な機能に分解します。」
- 「受け入れ基準を使用して、このエピック（URLを入力）のユーザーストーリーを作成します。」
- 「このユーザーストーリーを実装するには、どのようなタスクが必要ですか？」
- 「このプロジェクトの段階的なアプローチを提案します。（URLを入力）」
- 「この機能のMVPバージョンは何ですか。（URLを入力）」
- 「バージョン1に必要な機能、オプションの機能、およびその理由を特定します。（URLを入力）」
- 「これらの20個のイシュー（フィルター条件を入力）をQ1のスプリント全体で整理する方法を提案します。」
- 「スコープを縮小するために、このエピック（URLを入力）でどの作業を延期する必要がありますか？」
- 「このバックログ（フィルター条件を入力）をレビューし、改善が必要なアイテムを特定します。」
- 「このイニシアチブで機能をどのようにシーケンスする必要がありますか。（URLを入力）？」
- 「これらのイシューを論理的なリリーステーマにグループ化します。（URLを入力）」
- 「このエピックの進捗状況のエグゼクティブサマリーを生成します。（URLを入力）」
- 「（関連するマイルストーンまたはイテレーションを入力）に割り当てられたイシューに基づいて、リリースノートを起草します。」
- 「このイニシアチブの健全性に関する関係者アップデートを作成します。（URLを入力）」
- 「リーダーシップのためにブロッカーと軽減計画を要約します。（URLを入力）」
- 「6か月間更新されていない古いイシューを見つけます。」
- 「このプロジェクトで重複または類似のイシューを特定します。」
- 「どのイシューに見積もりまたはアサイン先がありませんか？」
- 親のない孤立したイシューを特定します。
- 「どのイシューが期日を過ぎていますか？」
