---
stage: Security Risk Management
group: Security Insights
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: セキュリティスキャンの結果
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

{{< history >}}

- GitLab 17.9で`dependency_scanning_for_pipelines_with_cyclonedx_reports`[フラグ](../../../administration/feature_flags/_index.md)とともに[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/490334)されました。デフォルトでは無効になっています。
- GitLab 17.9の[GitLab.comおよびGitLab Self-Managed](https://gitlab.com/gitlab-org/gitlab/-/issues/490332)で有効になりました。
- 機能フラグ`dependency_scanning_for_pipelines_with_cyclonedx_reports`は17.10で削除されました。

{{< /history >}}

GitLabでパイプラインセキュリティスキャンの結果を表示して、対応します。パイプラインで実行するセキュリティスキャナーを選択し、セキュリティレポートを出力します。これらのレポートの内容は処理され、GitLabに表示されます。

セキュリティスキャンの結果を理解するための主要な用語:

発見事項: 発見事項は、開発ブランチで特定された潜在的な脆弱性です。発見事項は、ブランチがデフォルトブランチにマージされると、脆弱性になります: 発見事項は、関連するCI/CDジョブアーティファクトが期限切れになるか、関連するジョブアーティファクトがロックされている場合でも、パイプラインの作成後90日で期限切れになります。

脆弱性: 脆弱性は、デフォルトブランチで特定されたソフトウェアセキュリティの弱点です。 脆弱性レコードは、[アーカイブ](../vulnerability_archival/_index.md)されるまで保持されます。たとえ脆弱性がデフォルトブランチで検出されなくなったとしても保持されます。

セキュリティスキャンの結果の表示は、[パイプラインの種類](../../../ci/pipelines/pipeline_types.md)（ブランチパイプラインまたはマージリクエストパイプライン）によって異なります。

デフォルトブランチで特定された脆弱性は、[脆弱性レポート](../vulnerability_report/_index.md)にリストされています。

| 脆弱性情報                          | ブランチ<br />パイプライン                                              | マージリクエスト</br >パイプライン |
|----------------------------------------------------|-------------------------------------------------------------------|-----------------------------|
| セキュリティレポート                                   | {{< icon name="check-circle-filled" >}}対応                       | {{< icon name="check-circle-filled" >}}対応 |
| パイプラインセキュリティレポート<br />Ultimateのみ      | {{< icon name="check-circle-filled" >}}対応                       | {{< icon name="check-circle-filled" >}}対応 |
| マージリクエストのセキュリティウィジェット<br />Ultimateのみ | {{< icon name="dash-circle" >}}対象外                                | {{< icon name="check-circle-filled" >}}対応 |
| 脆弱性レポート                               | {{< icon name="check-circle-filled" >}}はい - デフォルトブランチのみ | {{< icon name="dash-circle" >}}対象外 |

## セキュリティレポートアーティファクト {#security-report-artifacts}

セキュリティスキャナーはブランチパイプラインで実行され、有効になっている場合は、マージリクエストパイプラインで実行されます。各セキュリティスキャナーは、特定のセキュリティスキャナーによって検出されたすべての発見事項または脆弱性の詳細を含むセキュリティレポートアーティファクトを出力します。これらをダウンロードして、GitLabの外部で分析できます。

開発（非デフォルト）ブランチでは、発見事項には、開発ブランチの作成時にターゲットブランチに存在する脆弱性が含まれます。

期限切れの発見事項は、パイプラインの**セキュリティ**タブには表示されません。これらを再現するには、パイプラインを再実行します。

### セキュリティレポートのダウンロード {#download-a-security-report}

{{< details >}}

- プラン: Ultimate

{{< /details >}}

セキュリティレポートをダウンロードして、たとえば、GitLabの外部で分析したり、アーカイブ目的で使用したりできます。セキュリティレポートはJSONファイルです。

セキュリティレポートをダウンロードするには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **ビルド** > **パイプライン**を選択します。
1. パイプラインを選択します。
1. **セキュリティ**タブを選択します。
1. **結果をダウンロード**を選択し、目的のセキュリティレポートを選択します。

選択したセキュリティレポートがデバイスにダウンロードされます。

![セキュリティレポートの一覧](img/security_report_v18_1.png)

## パイプラインセキュリティレポート {#pipeline-security-report}

{{< details >}}

- プラン: Ultimate

{{< /details >}}

パイプラインセキュリティレポートには、ブランチで検出されたすべての発見事項または脆弱性の詳細が含まれています。デフォルトブランチに対して実行されたパイプラインの場合、パイプラインセキュリティレポート内のすべての脆弱性は、脆弱性レポートにも含まれています。

発見事項または脆弱性ごとに、次のことができます:

- その説明を選択して、詳細を表示します。
- 重大度またはステータスを変更します。
- 是正または軽減するために行われたアクションを追跡、ドキュメント化、および管理するために、GitLabイシューを作成します。

![ブランチ内の発見事項リスト](img/pipeline_security_report_v18_1.png)

### パイプラインセキュリティレポートを表示 {#view-pipeline-security-report}

パイプラインセキュリティレポートを表示して、ブランチで検出されたすべての発見事項または脆弱性の詳細を確認します。

パイプラインセキュリティレポートを表示するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **ビルド** > **パイプライン**を選択します。
1. 最新のパイプラインを選択します。

発見事項または脆弱性の詳細を表示するには、その説明を選択します。

### ステータスまたは重大度の変更 {#change-status-or-severity}

パイプラインのセキュリティタブで、発見事項または脆弱性のステータス、重大度、またはその両方を変更できます。発見事項に加えられた変更は、ブランチがデフォルトブランチにマージされると保持されます。

前提要件: 

- プロジェクトのメンテナーロール、または`admin_vulnerability`カスタム権限が少なくとも必要です。

発見事項または脆弱性のステータスと重大度を変更するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **ビルド** > **パイプライン**を選択します。
1. 最新のパイプラインを選択します。
1. **セキュリティ**タブを選択します。
1. 発見事項レポート内:

     1. 変更する発見事項または脆弱性を選択します。

        - 個々の脆弱性を選択するには、それぞれの横にあるチェックボックスを選択します。
        - ページ上のすべての検出結果または脆弱性を選択するには、テーブルヘッダーのチェックボックスを選択します。

     1. **アクションを選択**ドロップダウンリストで、**ステータスの変更**または**重大度の変更**を選択します。

### イシューを作成 {#create-an-issue}

発見事項または脆弱性の修正作業を追跡、ドキュメント化、および管理するためのイシューを作成します。

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **ビルド** > **パイプライン**を選択します。
1. パイプラインを選択します。
1. **セキュリティ**タブを選択します。
1. 発見事項の説明を選択します。
1. **イシューの作成**を選択します。

イシューがプロジェクトに作成され、発見事項または脆弱性の説明からコピーされた説明が追加されます。

## マージリクエストのウィジェット {#merge-request-security-widget}

{{< details >}}

- プラン: Ultimate

{{< /details >}}

マージリクエストには、変更によって発見事項にどのような差が生じるかの概要を示すセキュリティウィジェットが表示されます。CI/CDパイプラインがスキャン結果を処理するには時間がかかるため、セキュリティウィジェットが表示されるまでに遅延が生じる可能性があります。

たとえば、次のスキャン結果を持つ2つのパイプラインについて考えてみます:

- ソースブランチのパイプラインは、`V1`および`V2`として識別される2つの脆弱性を検出します。
- ターゲットブランチのパイプラインは、`V1`および`V3`として識別される2つの脆弱性を検出します。
- `V2`マージリクエストウィジェットに「追加」として表示されます。
- `V3`マージリクエストウィジェットに「修正済み」として表示されます。
- `V1`は両方のブランチに存在し、マージリクエストウィジェットには表示されません。

ソースブランチとターゲットブランチの違いを表示するには、両方のセキュリティレポートが必要です。フィーチャーブランチがターゲットブランチから作成されたときのコミットに対する最新の10個のパイプラインで、セキュリティレポートがチェックされます。最新の10個のパイプラインで見つからない場合、すべての発見事項が新規としてリストされます。マージリクエストでセキュリティスキャンを有効にする前に、デフォルトブランチに対してセキュリティスキャンが有効になっていることを確認してください。

### セキュリティウィジェットの表示 {#view-security-widget}

マージリクエストセキュリティウィジェットを表示して、変更によって発見事項にどのような差が生じるかを確認します。

セキュリティウィジェットを表示するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **マージリクエスト**を選択します。
1. マージリクエストを選択します。

セキュリティレポートの種類ごとに詳細を表示するには、**詳細を表示**（{{< icon name="chevron-down" >}}）を選択します。セキュリティレポートの種類ごとに、ウィジェットには、追加された上位25件と修正された上位25件の発見事項が重大度別にソートされて表示されます。マージリクエストのソースブランチにあるすべての発見事項を表示するには、**すべてのパイプラインの検証結果を表示する**を選択します。

![マージリクエストにおけるセキュリティスキャンの結果](img/mr_security_widget_v18_1.png)

## トラブルシューティング {#troubleshooting}

セキュリティスキャンを使用していると、次の問題が発生する可能性があります。

### MRセキュリティウィジェットに、無視された脆弱性が表示されます {#dismissed-vulnerabilities-are-visible-in-mr-security-widget}

マージリクエストでセキュリティウィジェットを表示すると、無視された脆弱性がまだリストされている場合があります。

この問題に対するソリューションはまだありません。詳細については、[イシュー411235](https://gitlab.com/gitlab-org/gitlab/-/issues/411235)を参照してください。

### レポートの解析中およびスキャンの取り込みエラー {#report-parsing-and-scan-ingestion-errors}

{{< alert type="note" >}}

これらの手順は、GitLabサポートがこのようなエラーを再現するために使用するものです。

{{< /alert >}}

一部のセキュリティスキャンでは、レポートの解析中またはスキャンの取り込みに関連するパイプラインの**セキュリティ**タブでエラーが発生する可能性があります。ユーザーからプロジェクトのコピーを取得できない場合は、スキャンから生成されたレポートを使用してエラーを再現できます。

エラーを再作成するには:

1. ユーザーからレポートのコピーを取得します。この例では、`gl-sast-report.json`です。
1. プロジェクトを作成。
1. レポートをリポジトリにコミットします。
1. `.gitlab-ci.yml`ファイルを追加し、ジョブでアーティファクトとしてレポートを含めます。

   たとえば、SASTジョブによって引き起こされたエラーを再現するには:

   ```yaml
   sample-job:
     script:
       - echo "Testing report"
     artifacts:
       reports:
         sast: gl-sast-report.json
   ```

1. パイプラインが完了したら、パイプラインの**セキュリティ**タブの内容を調べて、エラーがないか確認します。

`sast: gl-sast-report.json`をそれぞれの[`artifacts:reports`](../../../ci/yaml/_index.md#artifactsreports)タイプと、レポートを生成したスキャンに応じて、正しいJSONレポートファイル名に置き換えることができます。
