---
stage: Plan
group: Optimize
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: マージリクエストのコードレビュープロセスの効率性と、チームの生産性を理解するのに役立つマージリクエスト分析。
title: マージリクエスト分析
---

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

マージリクエスト分析は、DevOpsマネージャーに、チームのコードレビューおよびマージワークフローに関する貴重なインサイトを提供します。マージリクエストに関連する詳細なメトリクスと傾向に基づいて、組織は開発プロセスを監視および最適化できます。

マージリクエスト分析を使用して、以下を表示します:

- 組織が1か月あたりにマージしたマージリクエスト数。
- マージリクエストの作成からマージイベントまでの平均時間。
- マージされた各マージリクエストに関する情報（マイルストーン、コミット、行の変更、担当者など）。

マージリクエスト分析を使用して、以下を特定できます:

- 生産性の低い月、または高い月。
- 貴社のマージリクエストとコードレビュープロセスの効率性と生産性。

これらのインサイトは、次のようなデータに基づいた意思決定を行うのに役立ちます:

- リソースの割り当て: リソースを再配分するか、タイムラインを調整して、生産性の低い期間に対処します。
- パフォーマンスベンチマーク: 実績の高いチームにスポットライトを当て、ベストプラクティスを共有します。
- マイルストーン計画: 過去のマージ傾向に基づいてタイムラインを調整します。
- プロセス最適化: コードレビューとマージワークフローのボトルネックを特定して解決する。

## マージリクエスト分析を表示 {#view-merge-request-analytics}

前提要件:

- レポーターロール以上が必要です。

マージリクエスト分析を表示するには、:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **分析** > **分析ダッシュボード**を選択します。
1. **マージリクエスト分析**を選択します。

![マージリクエスト分析チャート](img/mr_analytics_chart_v17_7.png)

## 日付範囲内のマージリクエスト数を表示する {#view-the-number-of-merge-requests-in-a-date-range}

特定の日付範囲内にマージされたマージリクエスト数を表示するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **分析** > **分析ダッシュボード**を選択します。
1. **マージリクエスト分析**を選択します。
1. オプション。結果をフィルター:
   1. フィルターバーを選択します。
   1. パラメータを選択します。
   1. 値を1つ選択するか、テキストを入力して結果を絞り込みます。
   1. 日付範囲を調整するには、ドロップダウンリストからオプションを1つ選択します。**Last 365 days**（過去365日間）がデフォルトです。

**スループット**チャートは、一定期間にわたってクローズされたイシューまたはマージされたマージリクエストを示します。

テーブルには、ページあたり最大20件のマージリクエストが表示され、各マージリクエストに関する次の情報が含まれています:

- マージリクエスト名
- マージ日
- マージまでの時間
- マイルストーン
- コミット
- パイプライン
- 変更された行
- 担当者

## マージリクエストの作成とマージの間の平均時間を表示する {#view-average-time-between-merge-request-creation-and-merge}

**マージまでにかかる平均時間**の数値は、マージリクエストが作成されてからマージされるまでの平均時間を示しています。クローズ済みで、まだマージされていないマージリクエストは含まれていません。

**マージまでにかかる平均時間**を表示するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **分析** > **分析ダッシュボード**を選択します。
1. **マージリクエスト分析**を選択します。**マージまでにかかる平均時間**の数値がダッシュボードに表示されます。
