---
stage: none
group: unassigned
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: インテグレーションの管理
description: "GitLab Self-Managedインスタンスのプロジェクトおよびグループインテグレーションの設定を構成および管理します。"
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

{{< alert type="note" >}}

このページでは、プロジェクトとグループのインテグレーションに関する管理者向けドキュメントを掲載しています。ユーザー向けドキュメントは、[プロジェクトインテグレーション](../../user/project/integrations/_index.md)を参照してください。

{{< /alert >}}

プロジェクト管理者とグループ管理者は、インテグレーションを構成して有効にすることができます。インスタンスの管理者として、次のことができます:

- インテグレーションのデフォルトの設定パラメータを設定します。
- 許可リストを構成して、GitLabインスタンスで有効にできるインテグレーションを制御します。

## インテグレーションのデフォルトの設定を構成する {#configure-default-settings-for-an-integration}

前提要件: 

- インスタンスへの管理者アクセス権が必要です。

インテグレーションのデフォルトの設定を構成するには、次の手順に従います:

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **設定** > **インテグレーション**を選択します。
1. インテグレーションを選択します。
1. フィールドに入力します。
1. **変更を保存**を選択します。

{{< alert type="warning" >}}

これは、GitLabインスタンス上のグループとプロジェクトのすべてまたはほとんどに影響を与える可能性があります。以下の詳細を確認してください。

{{< /alert >}}

インテグレーションのインスタンスレベルの設定を初めてセットアップする場合:

- インスタンスレベルの設定で**インテグレーションを有効にする**切替がオンになっている場合、このインテグレーションがまだ構成されていないすべてのグループとプロジェクトに対して、インテグレーションが有効になります。
- すでにインテグレーションが構成されているグループとプロジェクトは影響を受けませんが、いつでも継承された設定を使用することを選択できます。

インスタンスのデフォルトをさらに変更すると、次のようになります:

- デフォルトの設定を使用するように設定されたインテグレーションを持つすべてのグループとプロジェクトに即座に適用されます。
- 最後にインテグレーションのデフォルトを保存した後に作成された、新しいグループとプロジェクトに即座に適用されます。インスタンスレベルのデフォルトの設定に**インテグレーションを有効にする**切替がオンになっている場合、そのようなすべてのグループとプロジェクトに対して、インテグレーションが自動的に有効になります。
- インテグレーションにカスタム設定が選択されているグループとプロジェクトは、すぐに影響を受けることはなく、いつでも最新のデフォルトを使用することを選択できます。

同じインテグレーションに対して[グループレベルの設定](../../user/project/integrations/_index.md#manage-group-default-settings-for-a-project-integration)も構成されている場合、そのグループ内のプロジェクトは、インスタンスレベルの設定の代わりに、グループレベルの設定を継承します。

インテグレーションの設定全体のみを継承できます。フィールドごとの継承は、[エピック2137](https://gitlab.com/groups/gitlab-org/-/epics/2137)で提案されています。

### インテグレーションのデフォルトの設定を削除する {#remove-default-settings-for-an-integration}

前提要件: 

- インスタンスへの管理者アクセス権が必要です。

インテグレーションのデフォルトの設定を削除するには、次の手順に従います:

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **設定** > **インテグレーション**を選択します。
1. インテグレーションを選択します。
1. **リセット**を選択して確定します。

インスタンスレベルのデフォルトの設定をリセットすると、デフォルトの設定を使用するように設定されたインテグレーションが、すべてのプロジェクトから削除されます。

### カスタム設定を使用するプロジェクトを表示する {#view-projects-that-use-custom-settings}

前提要件: 

- インスタンスへの管理者アクセス権が必要です。

[カスタム設定を使用](../../user/project/integrations/_index.md#use-custom-settings-for-a-project-or-group-integration)するインスタンス内のプロジェクトを表示するには:

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **設定** > **インテグレーション**を選択します。
1. インテグレーションを選択します。
1. **カスタム設定を使用したプロジェクト**タブを選択します。

## インテグレーション許可リスト {#integration-allowlist}

{{< details >}}

- プラン: Ultimate

{{< /details >}}

{{< history >}}

- GitLab 17.7で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/500610)されました。

{{< /history >}}

デフォルトでは、プロジェクト管理者とグループ管理者は、インテグレーションを有効にすることができます。ただし、インスタンスの管理者は、許可リストを構成して、GitLabインスタンスで有効にできるインテグレーションを制御できます。

許可リストの設定によって後でブロックされた、有効になっているインテグレーションは無効になります。これらのインテグレーションが再度許可された場合、既存の設定で再度有効になります。

空の許可リストを構成すると、どのインテグレーションもインスタンスで許可されません。許可リストを構成すると、新しいGitLabインテグレーションはデフォルトで許可リストに登録されません。

### 一部のインテグレーションを許可する {#allow-some-integrations}

前提要件: 

- インスタンスへの管理者アクセス権が必要です。

許可リストにあるインテグレーションのみを許可するには、次の手順を実行します:

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **設定** > **一般**を選択します。
1. **インテグレーション設定**セクションを展開します。
1. **次から選んだインテグレーションのみを許可する**を選択します。
1. インスタンスで許可する各インテグレーションのチェックボックスを選択します。
1. **変更を保存**を選択します。

### すべてのインテグレーションを許可する {#allow-all-integrations}

前提要件: 

- インスタンスへの管理者アクセス権が必要です。

GitLabインスタンス上のすべてのインテグレーションを許可するには:

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **設定** > **一般**を選択します。
1. **インテグレーション設定**セクションを展開します。
1. **すべてのインテグレーションを許可する**を選択します。
1. **変更を保存**を選択します。
