﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/chatbot/ChatbotRequest.h>
#include <aws/chatbot/Chatbot_EXPORTS.h>
#include <aws/chatbot/model/Tag.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
namespace chatbot {
namespace Model {

/**
 */
class CreateMicrosoftTeamsChannelConfigurationRequest : public ChatbotRequest {
 public:
  AWS_CHATBOT_API CreateMicrosoftTeamsChannelConfigurationRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "CreateMicrosoftTeamsChannelConfiguration"; }

  AWS_CHATBOT_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The ID of the Microsoft Teams channel.</p>
   */
  inline const Aws::String& GetChannelId() const { return m_channelId; }
  inline bool ChannelIdHasBeenSet() const { return m_channelIdHasBeenSet; }
  template <typename ChannelIdT = Aws::String>
  void SetChannelId(ChannelIdT&& value) {
    m_channelIdHasBeenSet = true;
    m_channelId = std::forward<ChannelIdT>(value);
  }
  template <typename ChannelIdT = Aws::String>
  CreateMicrosoftTeamsChannelConfigurationRequest& WithChannelId(ChannelIdT&& value) {
    SetChannelId(std::forward<ChannelIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the Microsoft Teams channel.</p>
   */
  inline const Aws::String& GetChannelName() const { return m_channelName; }
  inline bool ChannelNameHasBeenSet() const { return m_channelNameHasBeenSet; }
  template <typename ChannelNameT = Aws::String>
  void SetChannelName(ChannelNameT&& value) {
    m_channelNameHasBeenSet = true;
    m_channelName = std::forward<ChannelNameT>(value);
  }
  template <typename ChannelNameT = Aws::String>
  CreateMicrosoftTeamsChannelConfigurationRequest& WithChannelName(ChannelNameT&& value) {
    SetChannelName(std::forward<ChannelNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The ID of the Microsoft Teams authorized with AWS Chatbot.</p> <p>To get the
   * team ID, you must perform the initial authorization flow with Microsoft Teams in
   * the AWS Chatbot console. Then you can copy and paste the team ID from the
   * console. For more information, see <a
   * href="https://docs.aws.amazon.com/chatbot/latest/adminguide/teams-setup.html#teams-client-setup">Step
   * 1: Configure a Microsoft Teams client</a> in the <i> AWS Chatbot Administrator
   * Guide</i>. </p>
   */
  inline const Aws::String& GetTeamId() const { return m_teamId; }
  inline bool TeamIdHasBeenSet() const { return m_teamIdHasBeenSet; }
  template <typename TeamIdT = Aws::String>
  void SetTeamId(TeamIdT&& value) {
    m_teamIdHasBeenSet = true;
    m_teamId = std::forward<TeamIdT>(value);
  }
  template <typename TeamIdT = Aws::String>
  CreateMicrosoftTeamsChannelConfigurationRequest& WithTeamId(TeamIdT&& value) {
    SetTeamId(std::forward<TeamIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the Microsoft Teams Team.</p>
   */
  inline const Aws::String& GetTeamName() const { return m_teamName; }
  inline bool TeamNameHasBeenSet() const { return m_teamNameHasBeenSet; }
  template <typename TeamNameT = Aws::String>
  void SetTeamName(TeamNameT&& value) {
    m_teamNameHasBeenSet = true;
    m_teamName = std::forward<TeamNameT>(value);
  }
  template <typename TeamNameT = Aws::String>
  CreateMicrosoftTeamsChannelConfigurationRequest& WithTeamName(TeamNameT&& value) {
    SetTeamName(std::forward<TeamNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of the Microsoft Teams tenant.</p>
   */
  inline const Aws::String& GetTenantId() const { return m_tenantId; }
  inline bool TenantIdHasBeenSet() const { return m_tenantIdHasBeenSet; }
  template <typename TenantIdT = Aws::String>
  void SetTenantId(TenantIdT&& value) {
    m_tenantIdHasBeenSet = true;
    m_tenantId = std::forward<TenantIdT>(value);
  }
  template <typename TenantIdT = Aws::String>
  CreateMicrosoftTeamsChannelConfigurationRequest& WithTenantId(TenantIdT&& value) {
    SetTenantId(std::forward<TenantIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Names (ARNs) of the SNS topics that deliver notifications
   * to AWS Chatbot.</p>
   */
  inline const Aws::Vector<Aws::String>& GetSnsTopicArns() const { return m_snsTopicArns; }
  inline bool SnsTopicArnsHasBeenSet() const { return m_snsTopicArnsHasBeenSet; }
  template <typename SnsTopicArnsT = Aws::Vector<Aws::String>>
  void SetSnsTopicArns(SnsTopicArnsT&& value) {
    m_snsTopicArnsHasBeenSet = true;
    m_snsTopicArns = std::forward<SnsTopicArnsT>(value);
  }
  template <typename SnsTopicArnsT = Aws::Vector<Aws::String>>
  CreateMicrosoftTeamsChannelConfigurationRequest& WithSnsTopicArns(SnsTopicArnsT&& value) {
    SetSnsTopicArns(std::forward<SnsTopicArnsT>(value));
    return *this;
  }
  template <typename SnsTopicArnsT = Aws::String>
  CreateMicrosoftTeamsChannelConfigurationRequest& AddSnsTopicArns(SnsTopicArnsT&& value) {
    m_snsTopicArnsHasBeenSet = true;
    m_snsTopicArns.emplace_back(std::forward<SnsTopicArnsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A user-defined role that AWS Chatbot assumes. This is not the service-linked
   * role.</p> <p>For more information, see <a
   * href="https://docs.aws.amazon.com/chatbot/latest/adminguide/chatbot-iam-policies.html">IAM
   * policies for AWS Chatbot</a> in the <i> AWS Chatbot Administrator Guide</i>.
   * </p>
   */
  inline const Aws::String& GetIamRoleArn() const { return m_iamRoleArn; }
  inline bool IamRoleArnHasBeenSet() const { return m_iamRoleArnHasBeenSet; }
  template <typename IamRoleArnT = Aws::String>
  void SetIamRoleArn(IamRoleArnT&& value) {
    m_iamRoleArnHasBeenSet = true;
    m_iamRoleArn = std::forward<IamRoleArnT>(value);
  }
  template <typename IamRoleArnT = Aws::String>
  CreateMicrosoftTeamsChannelConfigurationRequest& WithIamRoleArn(IamRoleArnT&& value) {
    SetIamRoleArn(std::forward<IamRoleArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the configuration.</p>
   */
  inline const Aws::String& GetConfigurationName() const { return m_configurationName; }
  inline bool ConfigurationNameHasBeenSet() const { return m_configurationNameHasBeenSet; }
  template <typename ConfigurationNameT = Aws::String>
  void SetConfigurationName(ConfigurationNameT&& value) {
    m_configurationNameHasBeenSet = true;
    m_configurationName = std::forward<ConfigurationNameT>(value);
  }
  template <typename ConfigurationNameT = Aws::String>
  CreateMicrosoftTeamsChannelConfigurationRequest& WithConfigurationName(ConfigurationNameT&& value) {
    SetConfigurationName(std::forward<ConfigurationNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Logging levels include <code>ERROR</code>, <code>INFO</code>, or
   * <code>NONE</code>.</p>
   */
  inline const Aws::String& GetLoggingLevel() const { return m_loggingLevel; }
  inline bool LoggingLevelHasBeenSet() const { return m_loggingLevelHasBeenSet; }
  template <typename LoggingLevelT = Aws::String>
  void SetLoggingLevel(LoggingLevelT&& value) {
    m_loggingLevelHasBeenSet = true;
    m_loggingLevel = std::forward<LoggingLevelT>(value);
  }
  template <typename LoggingLevelT = Aws::String>
  CreateMicrosoftTeamsChannelConfigurationRequest& WithLoggingLevel(LoggingLevelT&& value) {
    SetLoggingLevel(std::forward<LoggingLevelT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The list of IAM policy ARNs that are applied as channel guardrails. The AWS
   * managed <code>AdministratorAccess</code> policy is applied by default if this is
   * not set. </p>
   */
  inline const Aws::Vector<Aws::String>& GetGuardrailPolicyArns() const { return m_guardrailPolicyArns; }
  inline bool GuardrailPolicyArnsHasBeenSet() const { return m_guardrailPolicyArnsHasBeenSet; }
  template <typename GuardrailPolicyArnsT = Aws::Vector<Aws::String>>
  void SetGuardrailPolicyArns(GuardrailPolicyArnsT&& value) {
    m_guardrailPolicyArnsHasBeenSet = true;
    m_guardrailPolicyArns = std::forward<GuardrailPolicyArnsT>(value);
  }
  template <typename GuardrailPolicyArnsT = Aws::Vector<Aws::String>>
  CreateMicrosoftTeamsChannelConfigurationRequest& WithGuardrailPolicyArns(GuardrailPolicyArnsT&& value) {
    SetGuardrailPolicyArns(std::forward<GuardrailPolicyArnsT>(value));
    return *this;
  }
  template <typename GuardrailPolicyArnsT = Aws::String>
  CreateMicrosoftTeamsChannelConfigurationRequest& AddGuardrailPolicyArns(GuardrailPolicyArnsT&& value) {
    m_guardrailPolicyArnsHasBeenSet = true;
    m_guardrailPolicyArns.emplace_back(std::forward<GuardrailPolicyArnsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Enables use of a user role requirement in your chat configuration.</p>
   */
  inline bool GetUserAuthorizationRequired() const { return m_userAuthorizationRequired; }
  inline bool UserAuthorizationRequiredHasBeenSet() const { return m_userAuthorizationRequiredHasBeenSet; }
  inline void SetUserAuthorizationRequired(bool value) {
    m_userAuthorizationRequiredHasBeenSet = true;
    m_userAuthorizationRequired = value;
  }
  inline CreateMicrosoftTeamsChannelConfigurationRequest& WithUserAuthorizationRequired(bool value) {
    SetUserAuthorizationRequired(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A map of tags assigned to a resource. A tag is a string-to-string map of
   * key-value pairs.</p>
   */
  inline const Aws::Vector<Tag>& GetTags() const { return m_tags; }
  inline bool TagsHasBeenSet() const { return m_tagsHasBeenSet; }
  template <typename TagsT = Aws::Vector<Tag>>
  void SetTags(TagsT&& value) {
    m_tagsHasBeenSet = true;
    m_tags = std::forward<TagsT>(value);
  }
  template <typename TagsT = Aws::Vector<Tag>>
  CreateMicrosoftTeamsChannelConfigurationRequest& WithTags(TagsT&& value) {
    SetTags(std::forward<TagsT>(value));
    return *this;
  }
  template <typename TagsT = Tag>
  CreateMicrosoftTeamsChannelConfigurationRequest& AddTags(TagsT&& value) {
    m_tagsHasBeenSet = true;
    m_tags.emplace_back(std::forward<TagsT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_channelId;

  Aws::String m_channelName;

  Aws::String m_teamId;

  Aws::String m_teamName;

  Aws::String m_tenantId;

  Aws::Vector<Aws::String> m_snsTopicArns;

  Aws::String m_iamRoleArn;

  Aws::String m_configurationName;

  Aws::String m_loggingLevel;

  Aws::Vector<Aws::String> m_guardrailPolicyArns;

  bool m_userAuthorizationRequired{false};

  Aws::Vector<Tag> m_tags;
  bool m_channelIdHasBeenSet = false;
  bool m_channelNameHasBeenSet = false;
  bool m_teamIdHasBeenSet = false;
  bool m_teamNameHasBeenSet = false;
  bool m_tenantIdHasBeenSet = false;
  bool m_snsTopicArnsHasBeenSet = false;
  bool m_iamRoleArnHasBeenSet = false;
  bool m_configurationNameHasBeenSet = false;
  bool m_loggingLevelHasBeenSet = false;
  bool m_guardrailPolicyArnsHasBeenSet = false;
  bool m_userAuthorizationRequiredHasBeenSet = false;
  bool m_tagsHasBeenSet = false;
};

}  // namespace Model
}  // namespace chatbot
}  // namespace Aws
