/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.urlconnection;

import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.utils.ProxyConfigProvider;
import software.amazon.awssdk.utils.StringUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
public final class ProxyConfiguration
implements ToCopyableBuilder<Builder, ProxyConfiguration> {
    private final URI endpoint;
    private final String username;
    private final String password;
    private final Set<String> nonProxyHosts;
    private final String host;
    private final int port;
    private final String scheme;
    private final boolean useSystemPropertyValues;
    private final boolean useEnvironmentVariablesValues;

    private ProxyConfiguration(DefaultClientProxyConfigurationBuilder builder) {
        String resolvedScheme;
        this.endpoint = builder.endpoint;
        this.scheme = resolvedScheme = this.resolveScheme(builder);
        ProxyConfigProvider proxyConfigProvider = ProxyConfigProvider.fromSystemEnvironmentSettings((Boolean)builder.useSystemPropertyValues, (Boolean)builder.useEnvironmentVariablesValues, (String)resolvedScheme);
        this.username = ProxyConfiguration.resolveUsername(builder, proxyConfigProvider);
        this.password = ProxyConfiguration.resolvePassword(builder, proxyConfigProvider);
        this.nonProxyHosts = ProxyConfiguration.resolveNonProxyHosts(builder, proxyConfigProvider);
        this.useSystemPropertyValues = builder.useSystemPropertyValues;
        if (builder.endpoint != null) {
            this.host = builder.endpoint.getHost();
            this.port = builder.endpoint.getPort();
        } else {
            this.host = proxyConfigProvider != null ? proxyConfigProvider.host() : null;
            this.port = proxyConfigProvider != null ? proxyConfigProvider.port() : 0;
        }
        this.useEnvironmentVariablesValues = builder.useEnvironmentVariablesValues;
    }

    private String resolveScheme(DefaultClientProxyConfigurationBuilder builder) {
        if (this.endpoint != null) {
            return this.endpoint.getScheme();
        }
        return builder.scheme;
    }

    private static String resolvePassword(DefaultClientProxyConfigurationBuilder builder, ProxyConfigProvider proxyConfigProvider) {
        if (builder.password != null || proxyConfigProvider == null) {
            return builder.password;
        }
        return proxyConfigProvider.password().orElseGet(() -> builder.password);
    }

    private static Set<String> resolveNonProxyHosts(DefaultClientProxyConfigurationBuilder builder, ProxyConfigProvider proxyConfigProvider) {
        return builder.nonProxyHosts != null || proxyConfigProvider == null ? builder.nonProxyHosts : proxyConfigProvider.nonProxyHosts();
    }

    private static String resolveUsername(DefaultClientProxyConfigurationBuilder builder, ProxyConfigProvider proxyConfigProvider) {
        if (builder.username != null || proxyConfigProvider == null) {
            return builder.username;
        }
        return proxyConfigProvider.userName().orElseGet(() -> builder.username);
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public String scheme() {
        return this.scheme;
    }

    public String username() {
        return this.username;
    }

    public String password() {
        return this.password;
    }

    public Set<String> nonProxyHosts() {
        return Collections.unmodifiableSet(this.nonProxyHosts != null ? this.nonProxyHosts : Collections.emptySet());
    }

    public Builder toBuilder() {
        return ProxyConfiguration.builder().endpoint(this.endpoint).username(this.username).password(this.password).nonProxyHosts(this.nonProxyHosts).useSystemPropertyValues(this.useSystemPropertyValues).scheme(this.scheme).useEnvironmentVariablesValues(this.useEnvironmentVariablesValues);
    }

    public static Builder builder() {
        return new DefaultClientProxyConfigurationBuilder();
    }

    public String toString() {
        return ToString.builder((String)"ProxyConfiguration").add("endpoint", (Object)this.endpoint).add("username", (Object)this.username).add("nonProxyHosts", this.nonProxyHosts).build();
    }

    public String resolveScheme() {
        return this.endpoint != null ? this.endpoint.getScheme() : this.scheme;
    }

    private static final class DefaultClientProxyConfigurationBuilder
    implements Builder {
        private URI endpoint;
        private String username;
        private String scheme = "http";
        private String password;
        private Set<String> nonProxyHosts;
        private Boolean useSystemPropertyValues = Boolean.TRUE;
        private Boolean useEnvironmentVariablesValues = Boolean.TRUE;

        private DefaultClientProxyConfigurationBuilder() {
        }

        @Override
        public Builder endpoint(URI endpoint) {
            if (endpoint != null) {
                Validate.isTrue((boolean)StringUtils.isEmpty((CharSequence)endpoint.getUserInfo()), (String)"Proxy endpoint user info is not supported.", (Object[])new Object[0]);
                Validate.isTrue((boolean)StringUtils.isEmpty((CharSequence)endpoint.getPath()), (String)"Proxy endpoint path is not supported.", (Object[])new Object[0]);
                Validate.isTrue((boolean)StringUtils.isEmpty((CharSequence)endpoint.getQuery()), (String)"Proxy endpoint query is not supported.", (Object[])new Object[0]);
                Validate.isTrue((boolean)StringUtils.isEmpty((CharSequence)endpoint.getFragment()), (String)"Proxy endpoint fragment is not supported.", (Object[])new Object[0]);
            }
            this.endpoint = endpoint;
            return this;
        }

        public void setEndpoint(URI endpoint) {
            this.endpoint(endpoint);
        }

        @Override
        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public void setUsername(String username) {
            this.username(username);
        }

        @Override
        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public void setPassword(String password) {
            this.password(password);
        }

        @Override
        public Builder nonProxyHosts(Set<String> nonProxyHosts) {
            this.nonProxyHosts = nonProxyHosts != null ? new HashSet<String>(nonProxyHosts) : null;
            return this;
        }

        @Override
        public Builder addNonProxyHost(String nonProxyHost) {
            if (this.nonProxyHosts == null) {
                this.nonProxyHosts = new HashSet<String>();
            }
            this.nonProxyHosts.add(nonProxyHost);
            return this;
        }

        public void setNonProxyHosts(Set<String> nonProxyHosts) {
            this.nonProxyHosts(nonProxyHosts);
        }

        @Override
        public Builder useSystemPropertyValues(Boolean useSystemPropertyValues) {
            this.useSystemPropertyValues = useSystemPropertyValues;
            return this;
        }

        public void setUseSystemPropertyValues(Boolean useSystemPropertyValues) {
            this.useSystemPropertyValues(useSystemPropertyValues);
        }

        @Override
        public Builder useEnvironmentVariablesValues(Boolean useEnvironmentVariablesValues) {
            this.useEnvironmentVariablesValues = useEnvironmentVariablesValues;
            return this;
        }

        @Override
        public Builder scheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        public void setScheme(String scheme) {
            this.scheme(scheme);
        }

        public void setUseEnvironmentVariablesValues(Boolean useEnvironmentVariablesValues) {
            this.useEnvironmentVariablesValues(useEnvironmentVariablesValues);
        }

        public ProxyConfiguration build() {
            return new ProxyConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ProxyConfiguration> {
        public Builder endpoint(URI var1);

        public Builder username(String var1);

        public Builder password(String var1);

        public Builder nonProxyHosts(Set<String> var1);

        public Builder addNonProxyHost(String var1);

        public Builder useSystemPropertyValues(Boolean var1);

        public Builder useEnvironmentVariablesValues(Boolean var1);

        public Builder scheme(String var1);
    }
}

