/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.search;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch.core.search.CompletionContext;
import org.opensearch.client.opensearch.core.search.FieldSuggester;
import org.opensearch.client.opensearch.core.search.FieldSuggesterVariant;
import org.opensearch.client.opensearch.core.search.SuggestFuzziness;
import org.opensearch.client.opensearch.core.search.SuggesterBase;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class CompletionSuggester
extends SuggesterBase
implements FieldSuggesterVariant,
ToCopyableBuilder<Builder, CompletionSuggester> {
    @Nonnull
    private final Map<String, List<CompletionContext>> contexts;
    @Nullable
    private final SuggestFuzziness fuzzy;
    @Nullable
    private final String regex;
    @Nullable
    private final Boolean skipDuplicates;
    public static final JsonpDeserializer<CompletionSuggester> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CompletionSuggester::setupCompletionSuggesterDeserializer);

    private CompletionSuggester(Builder builder) {
        super(builder);
        this.contexts = ApiTypeHelper.unmodifiable(builder.contexts);
        this.fuzzy = builder.fuzzy;
        this.regex = builder.regex;
        this.skipDuplicates = builder.skipDuplicates;
    }

    public static CompletionSuggester of(Function<Builder, ObjectBuilder<CompletionSuggester>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public FieldSuggester.Kind _fieldSuggesterKind() {
        return FieldSuggester.Kind.Completion;
    }

    @Nonnull
    public final Map<String, List<CompletionContext>> contexts() {
        return this.contexts;
    }

    @Nullable
    public final SuggestFuzziness fuzzy() {
        return this.fuzzy;
    }

    @Nullable
    public final String regex() {
        return this.regex;
    }

    @Nullable
    public final Boolean skipDuplicates() {
        return this.skipDuplicates;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.contexts)) {
            generator.writeKey("contexts");
            generator.writeStartObject();
            for (Map.Entry<String, List<CompletionContext>> item0 : this.contexts.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.writeStartArray();
                if (item0.getValue() != null) {
                    for (CompletionContext item1 : item0.getValue()) {
                        item1.serialize(generator, mapper);
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        if (this.fuzzy != null) {
            generator.writeKey("fuzzy");
            this.fuzzy.serialize(generator, mapper);
        }
        if (this.regex != null) {
            generator.writeKey("regex");
            generator.write(this.regex);
        }
        if (this.skipDuplicates != null) {
            generator.writeKey("skip_duplicates");
            generator.write(this.skipDuplicates.booleanValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupCompletionSuggesterDeserializer(ObjectDeserializer<Builder> op) {
        CompletionSuggester.setupSuggesterBaseDeserializer(op);
        op.add(Builder::contexts, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.arrayDeserializer(CompletionContext._DESERIALIZER)), "contexts");
        op.add(Builder::fuzzy, SuggestFuzziness._DESERIALIZER, "fuzzy");
        op.add(Builder::regex, JsonpDeserializer.stringDeserializer(), "regex");
        op.add(Builder::skipDuplicates, JsonpDeserializer.booleanDeserializer(), "skip_duplicates");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.contexts);
        result = 31 * result + Objects.hashCode(this.fuzzy);
        result = 31 * result + Objects.hashCode(this.regex);
        result = 31 * result + Objects.hashCode(this.skipDuplicates);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompletionSuggester other = (CompletionSuggester)o;
        return Objects.equals(this.contexts, other.contexts) && Objects.equals(this.fuzzy, other.fuzzy) && Objects.equals(this.regex, other.regex) && Objects.equals(this.skipDuplicates, other.skipDuplicates);
    }

    public static class Builder
    extends SuggesterBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, CompletionSuggester> {
        @Nullable
        private Map<String, List<CompletionContext>> contexts;
        @Nullable
        private SuggestFuzziness fuzzy;
        @Nullable
        private String regex;
        @Nullable
        private Boolean skipDuplicates;

        public Builder() {
        }

        private Builder(CompletionSuggester o) {
            super(o);
            this.contexts = Builder._mapCopy(o.contexts);
            this.fuzzy = o.fuzzy;
            this.regex = o.regex;
            this.skipDuplicates = o.skipDuplicates;
        }

        private Builder(Builder o) {
            super(o);
            this.contexts = Builder._mapCopy(o.contexts);
            this.fuzzy = o.fuzzy;
            this.regex = o.regex;
            this.skipDuplicates = o.skipDuplicates;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder contexts(Map<String, List<CompletionContext>> map) {
            this.contexts = Builder._mapPutAll(this.contexts, map);
            return this;
        }

        @Nonnull
        public final Builder contexts(String key, List<CompletionContext> value) {
            this.contexts = Builder._mapPut(this.contexts, key, value);
            return this;
        }

        @Nonnull
        public final Builder fuzzy(@Nullable SuggestFuzziness value) {
            this.fuzzy = value;
            return this;
        }

        @Nonnull
        public final Builder fuzzy(Function<SuggestFuzziness.Builder, ObjectBuilder<SuggestFuzziness>> fn) {
            return this.fuzzy(fn.apply(new SuggestFuzziness.Builder()).build());
        }

        @Nonnull
        public final Builder regex(@Nullable String value) {
            this.regex = value;
            return this;
        }

        @Nonnull
        public final Builder skipDuplicates(@Nullable Boolean value) {
            this.skipDuplicates = value;
            return this;
        }

        @Override
        @Nonnull
        public CompletionSuggester build() {
            this._checkSingleUse();
            return new CompletionSuggester(this);
        }
    }
}

