/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.expressions;

import java.io.IOException;
import org.apache.lucene.expressions.Bindings;
import org.apache.lucene.expressions.ExpressionRescorer;
import org.apache.lucene.expressions.ExpressionValueSource;
import org.apache.lucene.search.DoubleValues;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.search.Rescorer;
import org.apache.lucene.search.SortField;

public abstract class Expression {
    public final String sourceText;
    public final String[] variables;

    protected Expression(String sourceText, String[] variables) {
        this.sourceText = sourceText;
        this.variables = variables;
    }

    public abstract double evaluate(DoubleValues[] var1) throws IOException;

    public DoubleValuesSource getDoubleValuesSource(Bindings bindings) {
        return new ExpressionValueSource(bindings, this);
    }

    public SortField getSortField(Bindings bindings, boolean reverse) {
        return this.getDoubleValuesSource(bindings).getSortField(reverse);
    }

    public Rescorer getRescorer(Bindings bindings) {
        return new ExpressionRescorer(this, bindings);
    }
}

