/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import java.io.IOException;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.lucene.document.BinaryDocValuesField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.FieldExistsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.opensearch.common.util.BigArrays;
import org.opensearch.core.common.bytes.BytesArray;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.fielddata.IndexFieldData;
import org.opensearch.index.fielddata.plain.HllFieldData;
import org.opensearch.index.mapper.DocValueFetcher;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.index.mapper.MapperParsingException;
import org.opensearch.index.mapper.ParametrizedFieldMapper;
import org.opensearch.index.mapper.ParseContext;
import org.opensearch.index.mapper.TextSearchInfo;
import org.opensearch.index.mapper.ValueFetcher;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.aggregations.metrics.AbstractHyperLogLogPlusPlus;
import org.opensearch.search.lookup.SearchLookup;

public class HllFieldMapper
extends ParametrizedFieldMapper {
    public static final String CONTENT_TYPE = "hll";
    public static final ParametrizedFieldMapper.TypeParser PARSER = new ParametrizedFieldMapper.TypeParser((n, c) -> new Builder((String)n));
    private final int precision;

    private static HllFieldMapper toType(FieldMapper in) {
        return (HllFieldMapper)in;
    }

    private HllFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, int precision) {
        super(simpleName, mappedFieldType, multiFields, copyTo);
        this.precision = precision;
    }

    @Override
    protected void parseCreateField(ParseContext context) throws IOException {
        byte[] value = context.parseExternalValue(byte[].class);
        if (value == null) {
            if (context.parser().currentToken() == XContentParser.Token.VALUE_NULL) {
                return;
            }
            value = context.parser().binaryValue();
        }
        if (value == null) {
            return;
        }
        BytesRef sketchBytes = new BytesRef(value);
        this.validateSketchData(sketchBytes);
        context.doc().add((IndexableField)new BinaryDocValuesField(this.fieldType().name(), sketchBytes));
    }

    private void validateSketchData(BytesRef sketchBytes) throws MapperParsingException {
        try (StreamInput in = new BytesArray(sketchBytes.bytes, sketchBytes.offset, sketchBytes.length).streamInput();
             AbstractHyperLogLogPlusPlus sketch = AbstractHyperLogLogPlusPlus.readFrom(in, BigArrays.NON_RECYCLING_INSTANCE);){
            if (sketch.precision() != this.precision) {
                throw new MapperParsingException("HLL++ sketch precision mismatch for field [" + this.fieldType().name() + "]: expected " + this.precision + ", got " + sketch.precision());
            }
        }
        catch (MapperParsingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MapperParsingException("Invalid HLL++ sketch data for field [" + this.fieldType().name() + "]", e);
        }
    }

    @Override
    public HllFieldType fieldType() {
        return (HllFieldType)super.fieldType();
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public ParametrizedFieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName()).init(this);
    }

    public static final class HllFieldType
    extends MappedFieldType {
        private final int precision;

        public HllFieldType(String name, int precision, Map<String, String> meta) {
            super(name, false, false, true, TextSearchInfo.NONE, meta);
            this.precision = precision;
        }

        @Override
        public String typeName() {
            return HllFieldMapper.CONTENT_TYPE;
        }

        public int precision() {
            return this.precision;
        }

        @Override
        public ValueFetcher valueFetcher(QueryShardContext context, SearchLookup searchLookup, String format) {
            return new DocValueFetcher(this.docValueFormat(format, null), searchLookup.doc().getForField(this));
        }

        @Override
        public DocValueFormat docValueFormat(String format, ZoneId timeZone) {
            return DocValueFormat.BINARY;
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            this.failIfNoDocValues();
            return new HllFieldData.Builder(this.name(), this.precision);
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            return new FieldExistsQuery(this.name());
        }

        @Override
        public Query termQuery(Object value, QueryShardContext context) {
            throw new IllegalArgumentException("Term queries are not supported on [hll] fields");
        }
    }

    public static class Builder
    extends ParametrizedFieldMapper.Builder {
        private final ParametrizedFieldMapper.Parameter<Integer> precision = ParametrizedFieldMapper.Parameter.intParam("precision", false, m -> HllFieldMapper.toType((FieldMapper)m).precision, 14).setValidator(Builder::validatePrecision);
        private final ParametrizedFieldMapper.Parameter<Boolean> index = ParametrizedFieldMapper.Parameter.indexParam(m -> false, false).setValidator(v -> {
            if (v.booleanValue()) {
                throw new MapperParsingException("Cannot set [index] on field of type [hll]");
            }
        });
        private final ParametrizedFieldMapper.Parameter<Boolean> store = ParametrizedFieldMapper.Parameter.storeParam(m -> false, false).setValidator(v -> {
            if (v.booleanValue()) {
                throw new MapperParsingException("Cannot set [store] on field of type [hll]");
            }
        });
        private final ParametrizedFieldMapper.Parameter<Boolean> docValues = ParametrizedFieldMapper.Parameter.docValuesParam(m -> true, true).setValidator(v -> {
            if (!v.booleanValue()) {
                throw new MapperParsingException("Cannot disable [doc_values] on field of type [hll]");
            }
        });
        private final ParametrizedFieldMapper.Parameter<Map<String, String>> meta = ParametrizedFieldMapper.Parameter.metaParam();

        private static void validatePrecision(int precision) {
            if (precision < 4 || precision > 18) {
                throw new IllegalArgumentException("precision must be between 4 and 18, got: " + precision);
            }
        }

        public Builder(String name) {
            super(name);
        }

        @Override
        protected List<ParametrizedFieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.precision, this.index, this.store, this.docValues, this.meta);
        }

        @Override
        public HllFieldMapper build(Mapper.BuilderContext context) {
            return new HllFieldMapper(this.name, new HllFieldType(this.buildFullName(context), this.precision.getValue(), this.meta.getValue()), this.multiFieldsBuilder.build(this, context), this.copyTo.build(), this.precision.getValue());
        }
    }
}

