﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/athena/Athena_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Athena {
namespace Model {
class ListNamedQueriesResult {
 public:
  AWS_ATHENA_API ListNamedQueriesResult() = default;
  AWS_ATHENA_API ListNamedQueriesResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_ATHENA_API ListNamedQueriesResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The list of unique query IDs.</p>
   */
  inline const Aws::Vector<Aws::String>& GetNamedQueryIds() const { return m_namedQueryIds; }
  template <typename NamedQueryIdsT = Aws::Vector<Aws::String>>
  void SetNamedQueryIds(NamedQueryIdsT&& value) {
    m_namedQueryIdsHasBeenSet = true;
    m_namedQueryIds = std::forward<NamedQueryIdsT>(value);
  }
  template <typename NamedQueryIdsT = Aws::Vector<Aws::String>>
  ListNamedQueriesResult& WithNamedQueryIds(NamedQueryIdsT&& value) {
    SetNamedQueryIds(std::forward<NamedQueryIdsT>(value));
    return *this;
  }
  template <typename NamedQueryIdsT = Aws::String>
  ListNamedQueriesResult& AddNamedQueryIds(NamedQueryIdsT&& value) {
    m_namedQueryIdsHasBeenSet = true;
    m_namedQueryIds.emplace_back(std::forward<NamedQueryIdsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A token generated by the Athena service that specifies where to continue
   * pagination if a previous request was truncated. To obtain the next set of pages,
   * pass in the <code>NextToken</code> from the response object of the previous page
   * call.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListNamedQueriesResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListNamedQueriesResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<Aws::String> m_namedQueryIds;

  Aws::String m_nextToken;

  Aws::String m_requestId;
  bool m_namedQueryIdsHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Athena
}  // namespace Aws
